/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.dimension;

import com.yurtmod.dimension.TentDimension;
import com.yurtmod.structure.StructureType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TentTeleporter
extends Teleporter {
    private final StructureType structure;
    private final BlockPos tentCorner;
    private final double prevX;
    private final double prevY;
    private final double prevZ;
    private final int prevDimID;
    private final WorldServer worldServerTo;

    public TentTeleporter(int dimensionFrom, WorldServer worldTo, BlockPos corner, double oldX, double oldY, double oldZ, StructureType type) {
        super(worldTo);
        this.prevDimID = dimensionFrom;
        this.worldServerTo = worldTo;
        this.tentCorner = corner;
        this.prevX = oldX;
        this.prevY = oldY;
        this.prevZ = oldZ;
        this.structure = type;
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        double entityZ;
        double entityY;
        double entityX;
        float yaw = entity.field_70177_z;
        float pitch = entity.field_70125_A;
        entity.field_70179_y = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70159_w = 0.0;
        if (TentDimension.isTentDimension((World)this.worldServerTo)) {
            entityX = (double)this.tentCorner.func_177958_n() + 1.5;
            entityY = (double)this.tentCorner.func_177956_o() + 0.01;
            entityZ = (double)(this.tentCorner.func_177952_p() + this.structure.getDoorPosition()) + 0.5;
            yaw = -90.0f;
            this.structure.getNewStructure().generateInTentDimension(this.prevDimID, (World)this.worldServerTo, this.tentCorner.func_177958_n(), this.tentCorner.func_177952_p(), this.prevX, this.prevY, this.prevZ);
            this.worldServerTo.func_72912_H().func_76068_b(entity.func_184102_h().func_71218_a(0).func_72820_D());
        } else {
            entityX = this.prevX;
            entityY = this.prevY + 0.1;
            entityZ = this.prevZ;
        }
        entity.func_70012_b(entityX, entityY, entityZ, yaw, pitch);
        if (entity instanceof EntityPlayer) {
            entity.func_70634_a(entityX, entityY, entityZ);
        }
    }

    public boolean func_180620_b(Entity entity, float f) {
        return true;
    }

    public String toString() {
        String out = "\n[TentTeleporter]\nstructure=" + (Object)((Object)this.structure) + "\ntentCorner=" + this.tentCorner + "\nprevX=" + this.prevX + "\nprevY=" + this.prevY + "\nprevZ=" + this.prevZ + "\nprevDimID=" + this.prevDimID + "\nnextDimID=" + this.worldServerTo.field_73011_w.getDimension() + "\n";
        return out;
    }
}

